require( "scripts/style.lua" );
require( "scripts/luaDebug.lua" );

NameFont = {
  standardFont,
  20,
  BlackColor
};

HeaderFont = {
  standardFont,
  48,
  BlackColor
};

ButtonX = kCenter;
ButtonY = 90;
ButtonYSpace = 30;


-- Button Candy Graphics used by ALL buttons
Layer1HoleGraphics = 
{
	"images/metamap/game_available_venue1",
	"images/metamap/game_available_venue1_hl",
	"images/metamap/game_available_venue1_hl",
	"images/metamap/game_available_venue1"
}
Layer1NormalGraphics = 
{
	"images/metamap/game_done",
	"images/metamap/game_done_hl",
	"images/metamap/game_done_hl",
	"images/metamap/game_done"
}
Layer1ExpertGraphics = 
{
	"images/metamap/game_bonus_done",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done"
}
Layer2HoleGraphics = 
{
	"images/metamap/game_available_venue2",
	"images/metamap/game_available_venue2_hl",
	"images/metamap/game_available_venue2_hl",
	"images/metamap/game_available_venue2"
}
Layer2NormalGraphics = 
{
	"images/metamap/game_done",
	"images/metamap/game_done_hl",
	"images/metamap/game_done_hl",
	"images/metamap/game_done"
}
Layer2ExpertGraphics = 
{
	"images/metamap/game_bonus_done",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done"
}
Layer3HoleGraphics = 
{
	"images/metamap/game_available_venue3",
	"images/metamap/game_available_venue3_hl",
	"images/metamap/game_available_venue3_hl",
	"images/metamap/game_available_venue3"
}
Layer3NormalGraphics = 
{
	"images/metamap/game_done",
	"images/metamap/game_done_hl",
	"images/metamap/game_done_hl",
	"images/metamap/game_done"
}
Layer3ExpertGraphics = 
{
	"images/metamap/game_bonus_done",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done"
}
Layer4HoleGraphics = 
{
	"images/metamap/game_available_venue4",
	"images/metamap/game_available_venue4_hl",
	"images/metamap/game_available_venue4_hl",
	"images/metamap/game_available_venue4"
}
Layer4NormalGraphics = 
{
	"images/metamap/game_done",
	"images/metamap/game_done_hl",
	"images/metamap/game_done_hl",
	"images/metamap/game_done"
}
Layer4ExpertGraphics = 
{
	"images/metamap/game_bonus_done",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done"
}
Layer5HoleGraphics = 
{
	"images/metamap/game_available_venue5",
	"images/metamap/game_available_venue5_hl",
	"images/metamap/game_available_venue5_hl",
	"images/metamap/game_available_venue5"
}
Layer5NormalGraphics = 
{
	"images/metamap/game_done",
	"images/metamap/game_done_hl",
	"images/metamap/game_done_hl",
	"images/metamap/game_done"
}
Layer5ExpertGraphics = 
{
	"images/metamap/game_bonus_done",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done_hl",
	"images/metamap/game_bonus_done"
}

PlayDefaultButtonGraphics = {
	"buttons/highscores_btn_purp_idle.png",
	"buttons/highscores_btn_purp_down.png",
	"buttons/highscores_btn_purp_hl.png"
};

PlayDefaultFont = {
  standardFont,
  36,
  DarkPurpleColor
};

-- change to no
showAll="no";

buttonGapX = 25;
mapButtonX = {11, 529, 258, 27, 508}
mapButtonY = {205, 194, 367, 574, 559}

--store current for calendar
curVenue = GetCurrentVenue()
curLevel = GetCurrentLevel() + 1

--handle wrapping
if( curLevel > 10 )
then
	curLevel = curLevel - 10
	curVenue = curVenue + 1
end

config={ 
	-- the cake used to be a photo album
	album="yes"
}

function CalculateButtonGraphics(map, level)
	status = GetLevelStatus(map, level)
	
	-- if status is 0 then that means that the level should not be available at all
	if status == 0 then
		-- returning nil will give the button no graphics and make it unuseable
		return nil
	end
	
	-- if status is 1 then this level is the current level and a hole should be rendered
	if status == 1 then
		returnvalue = "Layer"..map.."HoleGraphics"
		return _G[returnvalue]
	end

	-- if status is 2 then this level was cleared without an expert score
	if status == 2 then
		returnvalue = "Layer"..map.."NormalGraphics"
		return _G[returnvalue]
	end

	-- if status is 3 then this level was cleared with an expert score
	if status == 3 then
		returnvalue = "Layer"..map.."ExpertGraphics"
		return _G[returnvalue]
	end

	-- this shouldn't happen
	DebugOut("Unable to determine button state in album.lua")
	return nil
end

x1 = 75;
y1 = 448;
xspacing1 = 38;
yspacing1 = -5;

x2 = 97;
y2 = 320;
xspacing2 = 31;
yspacing2 = -4;

x3 = 130;
y3 = 223;
xspacing3 = 25;
yspacing3 = -2;

x4 = 150;
y4 = 142;
xspacing4 = 22;
yspacing4 = 0;

x5 = 200;
y5 = 46;
xspacing5 = 15;
yspacing5 = 2.5;

-- Level marker locations
levelMarker1_1 = {x = x1, y = y1};
levelMarker1_2 = {x = x1 + xspacing1, y = y1 + yspacing1 + 10};
levelMarker1_3 = {x = x1 + xspacing1*2, y = y1 + yspacing1*2 + 16};
levelMarker1_4 = {x = x1 + xspacing1*3, y = y1 + yspacing1*3 + 18};
levelMarker1_5 = {x = x1 + xspacing1*4, y = y1 + yspacing1*4 + 20};
levelMarker1_6 = {x = x1 + xspacing1*5, y = y1 + yspacing1*5 + 18};
levelMarker1_7 = {x = x1 + xspacing1*6, y = y1 + yspacing1*6 + 16};
levelMarker1_8 = {x = x1 + xspacing1*7, y = y1 + yspacing1*7 + 12};
levelMarker1_9 = {x = x1 + xspacing1*8, y = y1 + yspacing1*8 + 8};
levelMarker1_10 = {x = x1 + xspacing1*9, y = y1 + yspacing1*9 + 0};
levelMarker2_1 = {x = x2, y = y2};
levelMarker2_2 = {x = x2 + xspacing2, y = y2 + yspacing2 - 10};
levelMarker2_3 = {x = x2 + xspacing2*2, y = y2 + yspacing2*2 - 15};
levelMarker2_4 = {x = x2 + xspacing2*3, y = y2 + yspacing2*3 - 17};
levelMarker2_5 = {x = x2 + xspacing2*4, y = y2 + yspacing2*4 - 17};
levelMarker2_6 = {x = x2 + xspacing2*5, y = y2 + yspacing2*5 - 17};
levelMarker2_7 = {x = x2 + xspacing2*6, y = y2 + yspacing2*6 - 15};
levelMarker2_8 = {x = x2 + xspacing2*7, y = y2 + yspacing2*7 - 10};
levelMarker2_9 = {x = x2 + xspacing2*8, y = y2 + yspacing2*8 - 2};
levelMarker2_10 = {x = x2 + xspacing2*9, y = y2 + yspacing2*9 + 10};
levelMarker3_1 = {x = x3, y = y3};
levelMarker3_2 = {x = x3 + xspacing3, y = y3 + yspacing3 - 5};
levelMarker3_3 = {x = x3 + xspacing3*2, y = y3 + yspacing3*2 - 7};
levelMarker3_4 = {x = x3 + xspacing3*3, y = y3 + yspacing3*3 - 7};
levelMarker3_5 = {x = x3 + xspacing3*4, y = y3 + yspacing3*4 - 5};
levelMarker3_6 = {x = x3 + xspacing3*5, y = y3 + yspacing3*5 - 3};
levelMarker3_7 = {x = x3 + xspacing3*6, y = y3 + yspacing3*6 + 2};
levelMarker3_8 = {x = x3 + xspacing3*7, y = y3 + yspacing3*7 + 8};
levelMarker3_9 = {x = x3 + xspacing3*8, y = y3 + yspacing3*8 + 15};
levelMarker3_10 = {x = x3 + xspacing3*9, y = y3 + yspacing3*9 + 27};
levelMarker4_1 = {x = x4 + xspacing4*0, y = y4 + yspacing4*0};
levelMarker4_2 = {x = x4 + xspacing4*1, y = y4 + yspacing4*1 - 3};
levelMarker4_3 = {x = x4 + xspacing4*2, y = y4 + yspacing4*2 - 4};
levelMarker4_4 = {x = x4 + xspacing4*3, y = y4 + yspacing4*3 - 4};
levelMarker4_5 = {x = x4 + xspacing4*4, y = y4 + yspacing4*4 - 4};
levelMarker4_6 = {x = x4 + xspacing4*5, y = y4 + yspacing4*5 - 3};
levelMarker4_7 = {x = x4 + xspacing4*6, y = y4 + yspacing4*6};
levelMarker4_8 = {x = x4 + xspacing4*7, y = y4 + yspacing4*7 + 4};
levelMarker4_9 = {x = x4 + xspacing4*8, y = y4 + yspacing4*8 + 10};
levelMarker4_10 = {x = x4 + xspacing4*9, y = y4 + yspacing4*9 + 20};
levelMarker5_1 = {x = x5 + xspacing5*0, y = y5 + yspacing5*0 + 5};
levelMarker5_2 = {x = x5 + xspacing5*1, y = y5 + yspacing5*1 + 1};
levelMarker5_3 = {x = x5 + xspacing5*2, y = y5 + yspacing5*2 - 1};
levelMarker5_4 = {x = x5 + xspacing5*3, y = y5 + yspacing5*3 - 2};
levelMarker5_5 = {x = x5 + xspacing5*4, y = y5 + yspacing5*4 - 3};
levelMarker5_6 = {x = x5 + xspacing5*5, y = y5 + yspacing5*5 - 4};
levelMarker5_7 = {x = x5 + xspacing5*6, y = y5 + yspacing5*6 - 3};
levelMarker5_8 = {x = x5 + xspacing5*7, y = y5 + yspacing5*7 - 2};
levelMarker5_9 = {x = x5 + xspacing5*8, y = y5 + yspacing5*8};
levelMarker5_10 = {x = x5 + xspacing5*9, y = y5 + yspacing5*9 + 5};

kLevelInfoX = 509;
kLevelInfoY = 512;
kLevelInfoSpacing = 15;
kLevelInfoFontSize = 18;

MakeDialog
{
	Bitmap
	{ 
		image="images/metamap/metamap_bg",
		x=kCenter,
		y=kCenter,
		
		MetaMap
		{
			x = 0, y = 0, w=kMax, h=kMax,

			Button{
				x=20,
				y=550,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="back",
				label="common.back.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    PopModal();
					    SwapToModal("ui_scripts/screens/main_menu_scrn.lua");
					end
				
			};			
		
			-- Level info background
			Bitmap
			{
				name = "level_info_background";
				image = "backgrounds/levelinfo_bg";
				x = 445;
				y = 465;
				scale = 0.75;
			};
		
			-- Selected level indicator
			Text
			{
				font = { standardFont, kLevelInfoFontSize, BlackColor };				
				x=kLevelInfoX,
				y=kLevelInfoY+10,
				w=200,
				h=50,
				flags = kHAlignLeft + kVAlignTop,
				name = "current_level",
				label = "current_level"
			};			
			
			-- Best score indicator
			Text
			{
				font = { standardFont, kLevelInfoFontSize, BlackColor };				
				x=kLevelInfoX,
				y=kLevelInfoY + (kLevelInfoSpacing*2),
				w=200,
				h=50,
				flags = kHAlignLeft + kVAlignTop,
				name = "best_score",
				label = "best_score"
			};

			
			-- Beginner goal
			--[[Text
			{
				font = { standardFont, kLevelInfoFontSize, BlackColor };				
				x=kLevelInfoX+20,
				y=kLevelInfoY + (kLevelInfoSpacing*1),
				w=200,
				h=50,
				flags = kHAlignLeft + kVAlignTop,
				name = "beginner_goal",
				label = "beginner_goal"
			};
			
			-- Expert goal
			Text
			{
				font = { standardFont, kLevelInfoFontSize, BlackColor };				
				x=kLevelInfoX,
				y=kLevelInfoY + (kLevelInfoSpacing*2),
				w=200,
				h=50,
				flags = kHAlignLeft + kVAlignTop,
				name = "expert_goal",
				label = "expert_goal"
			};]]--

			
			Button{
				x=616,
				y=532,
				font = PlayDefaultFont,
				graphics = PlayDefaultButtonGraphics,
				name = "play",
				label = "common.play.label",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()						
						PlayButton();
					end
				
			};
		}
	}
}
